<?php
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/auth.php';
require_once '/opt/lampp/htdocs/masunzu_bar_hotel/includes/functions.php';
require_login();

$allowed_roles = ['DG', 'Board', 'DGA', 'Admin'];
if (!in_array($_SESSION['role_name'], $allowed_roles, true)) {
    header("Location: /masunzu_bar_hotel/dashboards/admin_dashboard.php");
    exit;
}

$search = trim($_GET['search'] ?? '');
$actionFilter = $_GET['action'] ?? '';
$startDate = $_GET['start_date'] ?? '';
$endDate = $_GET['end_date'] ?? '';

$validActions = ['create', 'edit'];

$conn = get_db_connection();
ensure_user_history_table($conn);

$sql = "SELECT uch.*, 
               target.full_name AS target_full_name,
               target.username AS target_username,
               actor.full_name AS actor_full_name,
               actor.username AS actor_username
        FROM user_change_history uch
        LEFT JOIN user target ON target.id = uch.target_user_id
        LEFT JOIN user actor ON actor.id = uch.changed_by
        WHERE 1=1";
$types = '';
$params = [];

if ($search !== '') {
    $like = '%' . $search . '%';
    $sql .= " AND (
        target.full_name LIKE ? OR target.username LIKE ? OR
        actor.full_name LIKE ? OR actor.username LIKE ?
    )";
    $types .= 'ssss';
    $params = array_merge($params, [$like, $like, $like, $like]);
}

if ($actionFilter !== '' && in_array($actionFilter, $validActions, true)) {
    $sql .= " AND uch.action = ?";
    $types .= 's';
    $params[] = $actionFilter;
}

if ($startDate !== '') {
    $sql .= " AND DATE(uch.created_at) >= ?";
    $types .= 's';
    $params[] = $startDate;
}

if ($endDate !== '') {
    $sql .= " AND DATE(uch.created_at) <= ?";
    $types .= 's';
    $params[] = $endDate;
}

$sql .= " ORDER BY uch.created_at DESC LIMIT 500";
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    $historyRows = [];
    $errorMessage = 'Impossible de charger l\'historique pour le moment.';
} else {
    if ($types !== '') {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $historyRows = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $errorMessage = '';
}
$conn->close();

include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/header.php';
?>
<div style="padding: 20px; background-color: #F4F0E4; min-height: 70vh;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <div>
            <h1 style="color: #4B2F1F; font-size: 28px; font-weight: 700; margin: 0 0 8px 0;">Historique des Utilisateurs</h1>
            <p style="color: #6B4F2F; margin: 0; font-size: 14px;">
                Suivez qui a créé ou modifié les comptes utilisateurs et consultez les détails des changements.
            </p>
        </div>
        <div style="background: linear-gradient(135deg, #4B2F1F 0%, #6B4F2F 100%); color: #F4F0E4; padding: 15px 25px; border-radius: 10px; text-align: center;">
            <p style="margin: 0; font-size: 12px; text-transform: uppercase; letter-spacing: 0.05em; opacity: 0.8;">Total enregistrements</p>
            <p style="margin: 5px 0 0; font-size: 28px; font-weight: 700;"><?php echo number_format(count($historyRows)); ?></p>
        </div>
    </div>

    <!-- Filters -->
    <form method="GET" style="display: grid; grid-template-columns: repeat(5, 1fr); gap: 15px; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.06); margin-bottom: 20px;">
        <div>
            <label style="display: block; font-weight: 600; color: #4B2F1F; margin-bottom: 5px; font-size: 13px;">Recherche</label>
            <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" placeholder="Utilisateur ou acteur" 
                   style="width: 100%; padding: 10px; border: 1px solid #B08968; border-radius: 8px; font-size: 14px; box-sizing: border-box;">
        </div>
        <div>
            <label style="display: block; font-weight: 600; color: #4B2F1F; margin-bottom: 5px; font-size: 13px;">Action</label>
            <select name="action" style="width: 100%; padding: 10px; border: 1px solid #B08968; border-radius: 8px; font-size: 14px; box-sizing: border-box;">
                <option value="">Toutes les actions</option>
                <option value="create" <?php echo $actionFilter === 'create' ? 'selected' : ''; ?>>Création</option>
                <option value="edit" <?php echo $actionFilter === 'edit' ? 'selected' : ''; ?>>Modification</option>
            </select>
        </div>
        <div>
            <label style="display: block; font-weight: 600; color: #4B2F1F; margin-bottom: 5px; font-size: 13px;">Date début</label>
            <input type="date" name="start_date" value="<?php echo htmlspecialchars($startDate); ?>" 
                   style="width: 100%; padding: 10px; border: 1px solid #B08968; border-radius: 8px; font-size: 14px; box-sizing: border-box;">
        </div>
        <div>
            <label style="display: block; font-weight: 600; color: #4B2F1F; margin-bottom: 5px; font-size: 13px;">Date fin</label>
            <input type="date" name="end_date" value="<?php echo htmlspecialchars($endDate); ?>" 
                   style="width: 100%; padding: 10px; border: 1px solid #B08968; border-radius: 8px; font-size: 14px; box-sizing: border-box;">
        </div>
        <div style="display: flex; align-items: flex-end; gap: 10px;">
            <button type="submit" style="flex: 1; background-color: #4B2F1F; color: #F4F0E4; padding: 11px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; font-size: 14px;">
                Filtrer
            </button>
            <a href="/masunzu_bar_hotel/modules/users/user_history.php" style="padding: 11px 15px; border: 1px solid #4B2F1F; border-radius: 8px; color: #4B2F1F; text-decoration: none; font-size: 14px;">
                Réinitialiser
            </a>
        </div>
    </form>

    <?php if (!empty($errorMessage)): ?>
        <div style="background: #ffe6e6; color: #8a1f1f; padding: 12px; border-radius: 8px; margin-bottom: 20px;">
            <?php echo htmlspecialchars($errorMessage); ?>
        </div>
    <?php endif; ?>

    <!-- Table -->
    <div style="background: #fff; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.06); overflow: hidden;">
        <div style="overflow-x: auto;">
            <table style="width: 100%; border-collapse: collapse; min-width: 800px;">
                <thead style="background-color: #4B2F1F; color: #F4F0E4;">
                    <tr>
                        <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Date & Heure</th>
                        <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Action</th>
                        <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Utilisateur concerné</th>
                        <th style="padding: 14px 16px; text-align: left; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Effectué par</th>
                        <th style="padding: 14px 16px; text-align: center; font-weight: 600; font-size: 13px; text-transform: uppercase; letter-spacing: 0.03em;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($historyRows)): ?>
                        <tr>
                            <td colspan="5" style="padding: 40px; text-align: center; color: #6B4F2F;">
                                <div style="font-size: 48px; margin-bottom: 10px;">📋</div>
                                <p style="margin: 0; font-size: 16px;">Aucun historique à afficher.</p>
                                <p style="margin: 5px 0 0; font-size: 13px; color: #999;">Essayez de modifier vos filtres de recherche.</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($historyRows as $index => $row): ?>
                            <?php
                                $details = json_decode($row['change_details'] ?? '', true);
                                if (!is_array($details)) {
                                    $details = ['détails' => $row['change_details']];
                                }
                                $actionLabel = $row['action'] === 'create' ? 'Création' : 'Modification';
                                $actionColor = $row['action'] === 'create' ? '#2E7D32' : '#F4A261';
                                $actionBg = $row['action'] === 'create' ? '#e6ffe6' : '#fff3e6';
                            ?>
                            <tr style="border-bottom: 1px solid #F4F0E4; transition: background-color 0.2s;" onmouseover="this.style.backgroundColor='#FDFBF7'" onmouseout="this.style.backgroundColor='transparent'">
                                <td style="padding: 14px 16px; color: #4B2F1F;">
                                    <div style="font-weight: 600;"><?php echo htmlspecialchars(date('d/m/Y', strtotime($row['created_at']))); ?></div>
                                    <div style="font-size: 12px; color: #6B4F2F;"><?php echo htmlspecialchars(date('H:i', strtotime($row['created_at']))); ?></div>
                                </td>
                                <td style="padding: 14px 16px;">
                                    <span style="display: inline-block; padding: 5px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; background-color: <?php echo $actionBg; ?>; color: <?php echo $actionColor; ?>;">
                                        <?php echo htmlspecialchars($actionLabel); ?>
                                    </span>
                                </td>
                                <td style="padding: 14px 16px;">
                                    <div style="font-weight: 600; color: #2C1810;"><?php echo htmlspecialchars($row['target_full_name'] ?? 'Utilisateur #' . $row['target_user_id']); ?></div>
                                    <div style="font-size: 12px; color: #6B4F2F;">@<?php echo htmlspecialchars($row['target_username'] ?? 'N/A'); ?></div>
                                </td>
                                <td style="padding: 14px 16px;">
                                    <div style="font-weight: 600; color: #2C1810;"><?php echo htmlspecialchars($row['actor_full_name'] ?? 'Utilisateur #' . $row['changed_by']); ?></div>
                                    <div style="font-size: 12px; color: #6B4F2F;">@<?php echo htmlspecialchars($row['actor_username'] ?? 'N/A'); ?></div>
                                </td>
                                <td style="padding: 14px 16px; text-align: center;">
                                    <button type="button" 
                                            class="view-details-btn"
                                            data-index="<?php echo $index; ?>"
                                            data-action="<?php echo htmlspecialchars($row['action']); ?>"
                                            data-action-label="<?php echo htmlspecialchars($actionLabel); ?>"
                                            data-date="<?php echo htmlspecialchars(date('d/m/Y à H:i', strtotime($row['created_at']))); ?>"
                                            data-target="<?php echo htmlspecialchars($row['target_full_name'] ?? 'Utilisateur #' . $row['target_user_id']); ?>"
                                            data-actor="<?php echo htmlspecialchars($row['actor_full_name'] ?? 'Utilisateur #' . $row['changed_by']); ?>"
                                            data-details='<?php echo htmlspecialchars(json_encode($details), ENT_QUOTES, 'UTF-8'); ?>'
                                            style="background-color: #4B2F1F; color: #F4F0E4; padding: 8px 16px; border: none; border-radius: 6px; cursor: pointer; font-size: 13px; font-weight: 500; transition: background-color 0.2s;"
                                            onmouseover="this.style.backgroundColor='#6B4F2F'" 
                                            onmouseout="this.style.backgroundColor='#4B2F1F'">
                                        Voir détails
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if (count($historyRows) >= 500): ?>
            <div style="padding: 12px; text-align: center; color: #6B4F2F; font-size: 13px; background-color: #FDFBF7; border-top: 1px solid #F4F0E4;">
                ⚠️ Affichage limité aux 500 derniers enregistrements. Affinez les filtres pour plus de détails.
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Details Modal -->
<div id="detailsModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); justify-content: center; align-items: center; z-index: 1000;">
    <div style="background: #fff; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); max-width: 600px; width: 90%; max-height: 80vh; overflow: hidden; animation: modalSlide 0.3s ease;">
        <div id="modalHeader" style="background: linear-gradient(135deg, #4B2F1F 0%, #6B4F2F 100%); color: #F4F0E4; padding: 20px; display: flex; justify-content: space-between; align-items: center;">
            <div>
                <h3 id="modalTitle" style="margin: 0; font-size: 18px; font-weight: 600;">Détails du changement</h3>
                <p id="modalSubtitle" style="margin: 5px 0 0; font-size: 13px; opacity: 0.8;"></p>
            </div>
            <button id="closeModal" style="background: rgba(255,255,255,0.2); border: none; color: #F4F0E4; width: 36px; height: 36px; border-radius: 50%; cursor: pointer; font-size: 20px; line-height: 1;">×</button>
        </div>
        <div style="padding: 20px; overflow-y: auto; max-height: calc(80vh - 80px);">
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px;">
                <div style="background: #FDFBF7; padding: 15px; border-radius: 8px;">
                    <p style="margin: 0 0 5px; font-size: 11px; color: #6B4F2F; text-transform: uppercase; letter-spacing: 0.05em;">Utilisateur concerné</p>
                    <p id="modalTarget" style="margin: 0; font-weight: 600; color: #2C1810;"></p>
                </div>
                <div style="background: #FDFBF7; padding: 15px; border-radius: 8px;">
                    <p style="margin: 0 0 5px; font-size: 11px; color: #6B4F2F; text-transform: uppercase; letter-spacing: 0.05em;">Effectué par</p>
                    <p id="modalActor" style="margin: 0; font-weight: 600; color: #2C1810;"></p>
                </div>
            </div>
            <div style="border-top: 1px solid #F4F0E4; padding-top: 20px;">
                <h4 style="margin: 0 0 15px; color: #4B2F1F; font-size: 14px; text-transform: uppercase; letter-spacing: 0.05em;">Détails des changements</h4>
                <div id="modalContent"></div>
            </div>
        </div>
    </div>
</div>

<style>
@keyframes modalSlide {
    from { opacity: 0; transform: translateY(-20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('detailsModal');
    const closeBtn = document.getElementById('closeModal');
    const modalTitle = document.getElementById('modalTitle');
    const modalSubtitle = document.getElementById('modalSubtitle');
    const modalTarget = document.getElementById('modalTarget');
    const modalActor = document.getElementById('modalActor');
    const modalContent = document.getElementById('modalContent');

    document.querySelectorAll('.view-details-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const action = this.dataset.action;
            const actionLabel = this.dataset.actionLabel;
            const date = this.dataset.date;
            const target = this.dataset.target;
            const actor = this.dataset.actor;
            const details = JSON.parse(this.dataset.details);

            modalTitle.textContent = actionLabel + ' d\'utilisateur';
            modalSubtitle.textContent = date;
            modalTarget.textContent = target;
            modalActor.textContent = actor;

            let contentHtml = '';
            if (action === 'create') {
                contentHtml = '<div style="display: grid; gap: 10px;">';
                for (const [key, value] of Object.entries(details)) {
                    contentHtml += `
                        <div style="display: flex; justify-content: space-between; padding: 10px 15px; background: #FDFBF7; border-radius: 6px; border-left: 3px solid #2E7D32;">
                            <span style="color: #6B4F2F; font-weight: 500;">${escapeHtml(key)}</span>
                            <span style="color: #2C1810; font-weight: 600;">${escapeHtml(String(value))}</span>
                        </div>
                    `;
                }
                contentHtml += '</div>';
            } else {
                contentHtml = '<div style="display: grid; gap: 10px;">';
                if (Array.isArray(details)) {
                    details.forEach(change => {
                        const field = change.champ || change.field || 'Champ';
                        const oldVal = change.ancien || '';
                        const newVal = change.nouveau || '';
                        contentHtml += `
                            <div style="padding: 12px 15px; background: #FDFBF7; border-radius: 6px; border-left: 3px solid #F4A261;">
                                <div style="font-weight: 600; color: #4B2F1F; margin-bottom: 8px;">${escapeHtml(field)}</div>
                                <div style="display: flex; align-items: center; gap: 10px; font-size: 14px;">
                                    <span style="background: #ffe6e6; color: #C62828; padding: 4px 10px; border-radius: 4px;">${escapeHtml(oldVal) || '<em>vide</em>'}</span>
                                    <span style="color: #6B4F2F;">→</span>
                                    <span style="background: #e6ffe6; color: #2E7D32; padding: 4px 10px; border-radius: 4px;">${escapeHtml(newVal) || '<em>vide</em>'}</span>
                                </div>
                            </div>
                        `;
                    });
                } else {
                    for (const [key, value] of Object.entries(details)) {
                        contentHtml += `
                            <div style="display: flex; justify-content: space-between; padding: 10px 15px; background: #FDFBF7; border-radius: 6px;">
                                <span style="color: #6B4F2F; font-weight: 500;">${escapeHtml(key)}</span>
                                <span style="color: #2C1810;">${escapeHtml(String(value))}</span>
                            </div>
                        `;
                    }
                }
                contentHtml += '</div>';
            }
            modalContent.innerHTML = contentHtml;
            modal.style.display = 'flex';
        });
    });

    closeBtn.addEventListener('click', function() {
        modal.style.display = 'none';
    });

    modal.addEventListener('click', function(e) {
        if (e.target === modal) {
            modal.style.display = 'none';
        }
    });

    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape' && modal.style.display === 'flex') {
            modal.style.display = 'none';
        }
    });

    function escapeHtml(text) {
        if (!text) return '';
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }
});
</script>

<?php include '/opt/lampp/htdocs/masunzu_bar_hotel/includes/footer.php'; ?>
