<?php
session_start();
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

$roleName = $_SESSION['role_name'] ?? '';
$allowedRoles = ['DG', 'DGA', 'Admin', 'Board', 'Chef Marketing', 'Agent Marketing', 'Accountant'];
if (!in_array($roleName, $allowedRoles, true)) {
    header("Location: /masunzu_bar_hotel/dashboards/unauthorized.php");
    exit;
}

$conn = get_db_connection();
if (!$conn) {
    die("<p style='color:#B00020;text-align:center;padding:20px;'>Impossible de se connecter à la base de données.</p>");
}

$searchTerm = trim(filter_input(INPUT_GET, 'search', FILTER_UNSAFE_RAW) ?? '');
$customerTypeFilter = strtolower(trim(filter_input(INPUT_GET, 'type', FILTER_UNSAFE_RAW) ?? ''));
$validCustomerTypes = ['physical', 'moral'];
$query = "
    SELECT 
        c.id,
        c.full_name,
        c.tel,
        c.nif,
        c.created_at,
        c.user_type,
        c.can_pay_by_loan,
        COALESCE(SUM(CASE
            WHEN ui.is_loan_sale = 1 
             AND ui.loan_outstanding_bif > 0
             AND (ui.approval_status IS NULL OR ui.approval_status != 'rejected')
            THEN ui.loan_outstanding_bif 
            ELSE 0 
        END), 0) AS loan_due,
        u.full_name AS created_by_name,
        u.username AS created_by_username
    FROM customer c
    LEFT JOIN user u ON c.created_by = u.id
    LEFT JOIN unpaid_invoices ui ON ui.customer_id = c.id
    WHERE 1=1
";
$params = [];
$types = '';
if ($searchTerm !== '') {
    $query .= " AND (c.full_name LIKE CONCAT('%', ?, '%') OR c.tel LIKE CONCAT('%', ?, '%') OR COALESCE(u.full_name, '') LIKE CONCAT('%', ?, '%'))";
    $params[] = $searchTerm;
    $params[] = $searchTerm;
    $params[] = $searchTerm;
    $types .= 'sss';
}
if (in_array($customerTypeFilter, $validCustomerTypes, true)) {
    $query .= " AND c.user_type = ?";
    $params[] = $customerTypeFilter;
    $types .= 's';
}
$query .= "
    GROUP BY c.id, c.full_name, c.tel, c.nif, c.created_at, c.user_type, c.can_pay_by_loan, u.full_name, u.username
    ORDER BY c.created_at DESC
";

$stmt = $conn->prepare($query);
if ($stmt === false) {
    $conn->close();
    die("<p style='color:#B00020;text-align:center;padding:20px;'>Erreur lors de la préparation de la requête.</p>");
}
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
$customers = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

?>
<?php include __DIR__ . '/../../includes/header.php'; ?>
<div style="padding: 20px;">
    <div style="background: #F4F0E4; border-radius: 12px; padding: 20px; box-shadow: 0 15px 35px rgba(75, 47, 31, 0.1);">
        <h1 style="color:#4B2F1F; margin-bottom: 10px;">Historique des créations de clients</h1>
        <p style="color:#6D4C41;">Vue centralisée de toutes les fiches clients et de leurs créateurs.</p>
        <form method="get" style="margin-top: 15px; display:flex; gap:10px; flex-wrap:wrap;">
            <input type="text" name="search" value="<?php echo htmlspecialchars($searchTerm, ENT_QUOTES, 'UTF-8'); ?>"
                   placeholder="Rechercher par nom, téléphone ou créateur"
                   style="flex:1; min-width:240px; padding:10px; border:1px solid #D7CCC8; border-radius:8px;">
            <select name="type" style="padding:10px 12px; border:1px solid #D7CCC8; border-radius:8px; min-width:200px; background:#fff;">
                <option value="" <?php echo $customerTypeFilter === '' ? 'selected' : ''; ?>>Tous types de clients</option>
                <option value="physical" <?php echo $customerTypeFilter === 'physical' ? 'selected' : ''; ?>>Personne physique</option>
                <option value="moral" <?php echo $customerTypeFilter === 'moral' ? 'selected' : ''; ?>>Personne morale</option>
            </select>
            <button type="submit" style="background:#7C4A33; color:#FFF; border:none; padding:10px 20px; border-radius:8px; cursor:pointer;">
                Filtrer
            </button>
        </form>

        <div style="margin-top:20px; overflow-x:auto;">
            <table style="width:100%; border-collapse:collapse;">
                <thead>
                    <tr style="background:#7C4A33; color:#FFF;">
                        <th style="padding:10px; text-align:left;">ID</th>
                        <th style="padding:10px; text-align:left;">Client</th>
                        <th style="padding:10px; text-align:left;">Type</th>
                        <th style="padding:10px; text-align:left;">Téléphone</th>
                        <th style="padding:10px; text-align:left;">Éligible Crédit</th>
                        <th style="padding:10px; text-align:left;">Crédit dû</th>
                        <th style="padding:10px; text-align:left;">Créé le</th>
                        <th style="padding:10px; text-align:left;">Créé par</th>
                        <th style="padding:10px; text-align:left;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (empty($customers)): ?>
                    <tr>
                        <td colspan="9" style="padding:14px; text-align:center; color:#6D4C41;">Aucun client trouvé.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($customers as $customer): ?>
                        <?php
                            $typeLabel = ($customer['user_type'] ?? 'physical') === 'moral' ? 'Personne Morale' : 'Personne Physique';
                            $loanEligible = ((int)($customer['can_pay_by_loan'] ?? 0) === 1) ? 'Oui' : 'Non';
                            $loanDue = (int)($customer['loan_due'] ?? 0);
                        ?>
                        <tr style="border-bottom:1px solid #E0E0E0;">
                            <td style="padding:12px;"><?php echo (int)$customer['id']; ?></td>
                            <td style="padding:12px;">
                                <strong><?php echo htmlspecialchars($customer['full_name'], ENT_QUOTES, 'UTF-8'); ?></strong><br>
                                <span style="color:#8D6E63;">NIF: <?php echo htmlspecialchars($customer['nif'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></span>
                            </td>
                            <td style="padding:12px;"><?php echo htmlspecialchars($typeLabel, ENT_QUOTES, 'UTF-8'); ?></td>
                            <td style="padding:12px;"><?php echo htmlspecialchars($customer['tel'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                            <td style="padding:12px;"><?php echo htmlspecialchars($loanEligible, ENT_QUOTES, 'UTF-8'); ?></td>
                            <td style="padding:12px;"><?php echo htmlspecialchars(number_format($loanDue, 0, ',', '.'), ENT_QUOTES, 'UTF-8'); ?> BIF</td>
                            <td style="padding:12px;"><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($customer['created_at'] ?? 'now')), ENT_QUOTES, 'UTF-8'); ?></td>
                            <td style="padding:12px;">
                                <?php if (!empty($customer['created_by_name'])): ?>
                                    <?php echo htmlspecialchars($customer['created_by_name'], ENT_QUOTES, 'UTF-8'); ?>
                                    <br><span style="color:#8D6E63;"><?php echo htmlspecialchars($customer['created_by_username'], ENT_QUOTES, 'UTF-8'); ?></span>
                                <?php else: ?>
                                    <span style="color:#8D6E63;">Non renseigné</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding:12px;">
                                <a href="/masunzu_bar_hotel/modules/customers/view_customer.php?id=<?php echo (int)$customer['id']; ?>"
                                   style="display:inline-block; padding:8px 16px; background:#7C4A33; color:#FFF; border-radius:8px; text-decoration:none; font-weight:600;">
                                   Voir
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
