<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();
$roleName = $_SESSION['role_name'] ?? '';
if (!in_array($roleName, ['DG', 'DGA', 'Admin'], true)) {
    header('Location: /masunzu_bar_hotel/dashboards/unauthorized.php');
    exit;
}

$conn = get_db_connection();
if (!$conn) {
    die('<p style="color:#B00020;text-align:center;padding:20px;">Connexion BD impossible.</p>');
}

$observations = [];
$stmt = $conn->prepare(
    "SELECT fo.id, fo.subject, fo.details, fo.created_at, r.name AS region_name, p.name AS depot_name, u.full_name AS author_name
    FROM field_observation fo
    LEFT JOIN region r ON fo.region_id = r.id
    LEFT JOIN province p ON fo.province_id = p.id
    LEFT JOIN user u ON fo.author_id = u.id
    ORDER BY fo.created_at DESC"
);
if ($stmt) {
    $stmt->execute();
    $observations = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
}
$conn->close();
include __DIR__ . '/../../includes/header.php';
?>
<div class="dashboard-container" style="padding:20px; background-color:#F4F0E4; min-height:80vh;">
    <div class="dashboard-content" style="background:#fff; padding:24px; border-radius:12px; box-shadow:0 12px 30px rgba(0,0,0,0.08);">
        <h2 style="color:#4B2F1F;">Observations terrain</h2>
        <p style="color:#6D4C41;">Vue consolidée des notes remontées par les équipes marketing et financières.</p>
        <div style="overflow-x:auto; margin-top:20px;">
            <table style="width:100%; border-collapse:collapse;">
                <thead>
                    <tr style="background:#4B2F1F;color:#F4F0E4;">
                        <th style="padding:12px; text-align:left;">Sujet</th>
                        <th style="padding:12px; text-align:left;">Auteur</th>
                        <th style="padding:12px; text-align:left;">Région / Dépôt</th>
                        <th style="padding:12px; text-align:left;">Créé le</th>
                        <th style="padding:12px; text-align:left;">Détails</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($observations)): ?>
                        <tr>
                            <td colspan="5" style="padding:14px; text-align:center; color:#6D4C41;">Aucune observation enregistrée.</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($observations as $obs): ?>
                            <tr style="border-bottom:1px solid #E0E0E0;">
                                <td style="padding:12px; vertical-align:top;"><?php echo htmlspecialchars($obs['subject'] ?? '-', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px; vertical-align:top;"><?php echo htmlspecialchars($obs['author_name'] ?? 'Inconnu', ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px; vertical-align:top;">
                                    <?php echo htmlspecialchars($obs['region_name'] ?? '—', ENT_QUOTES, 'UTF-8'); ?><br>
                                    <small style="color:#8D6E63;"><?php echo htmlspecialchars($obs['depot_name'] ?? 'Non défini', ENT_QUOTES, 'UTF-8'); ?></small>
                                </td>
                                <td style="padding:12px; vertical-align:top;"><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($obs['created_at'] ?? 'now')), ENT_QUOTES, 'UTF-8'); ?></td>
                                <td style="padding:12px; vertical-align:top;"><?php echo nl2br(htmlspecialchars($obs['details'] ?? '', ENT_QUOTES, 'UTF-8')); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php'; ?>
