<?php
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();

$role = $_SESSION['role_name'] ?? '';
if (!in_array($role, ['Caissier_Comptable', 'Marketing Agent'], true)) {
    error_log("Unauthorized access to create_sale.php by user {$_SESSION['full_name']} ({$role})");
    redirect('/masunzu_bar_hotel/modules/login/login.php');
}

include __DIR__ . '/../../includes/header.php';
?>
<div style="min-height: 80vh; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #4B2F1F 0%, #F4A261 100%); padding: 40px; box-sizing: border-box;">
    <div style="background: #F4F0E4; border-radius: 16px; padding: 40px; max-width: 640px; text-align: center; box-shadow: 0 8px 24px rgba(0,0,0,0.2);">
        <h1 style="color: #4B2F1F; margin-bottom: 16px;">Ventes Directes Désactivées</h1>
        <p style="color: #2E1A12; font-size: 16px; line-height: 1.6;">
            Les ventes au détail/directes ne sont plus disponibles sur la plateforme Masunzu. Toutes les transactions
            doivent être traitées via des commandes gros. Veuillez créer une commande gros et
            procéder au workflow d'approbation et de paiement standard.
        </p>
        <a href="/masunzu_bar_hotel/modules/cashiers/create_invoice.php" style="display: inline-block; margin-top: 24px; padding: 12px 24px; background-color: #4B2F1F; color: #F4F0E4; border-radius: 8px; text-decoration: none; font-weight: 600;">
            Créer Commande Gros
        </a>
    </div>
</div>
<?php include __DIR__ . '/../../includes/footer.php';
